//Caption: Verification of Sampling Theorem
//[1].Right Sampling [2]. Under Sampling [3]. Over Sampling
clc;
close;
clear;
fm=input('Enter the input signal frequency:'); 
k=input('Enter the number of Cycles of input signal:');
A=input('Enter the amplitude of input signal:');
tm=0:1/(fm*fm):k/fm;
x=A*cos(2*%pi*fm*tm);
figure(1);
a = gca();
a.x_location = "origin";
a.y_location = "origin";
plot(tm,x);
title('ORIGINAL SIGNAL');   
xlabel('Time');
ylabel('Amplitude');
xgrid(1)
//Sampling Rate(Nyquist Rate)=2*fm
fnyq=2*fm;
// UNDER SAMPLING
fs=(3/4)*fnyq;
n=0:1/fs:k/fm;
xn=A*cos(2*%pi*fm*n);
figure(2);
a = gca();
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',n,xn);
plot(n,xn,'r');
title('Under Sampling');
xlabel('Time');
ylabel('Amplitude');
legend('Sampled Signal', 'Reconstructed Signal');
xgrid(1)
//NYQUIST SAMPLING
fs=fnyq;
n=0:1/fs:k/fm;
xn=A*cos(2*%pi*fm*n);
figure(3);
a = gca();
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',n,xn);
plot(n,xn,'r');
title('Nyquist Sampling');
xlabel('Time');
ylabel('Amplitude');
legend('Sampled Signal', 'Reconstructed Signal');
xgrid(1)
//OVER SAMPLING
fs=fnyq*10;
n=0:1/fs:k/fm;
xn=A*cos(2*%pi*fm*n);
figure(4);
a = gca();
a.x_location = "origin";
a.y_location = "origin";
plot2d3('gnn',n,xn);
plot(n,xn,'r');
title('Over Sampling');
xlabel('Time');
ylabel('Amplitude');
legend('Sampled Signal', 'Reconstructed Signal');
xgrid(1)
//Result
//Enter the input signal frequency:100
//
//Enter the number of Cycles of input signal:2
//
//Enter the amplitude of input signal:2 